package com.ejie.aa17a.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aContaminanteEstacionDao;
import com.ejie.aa17a.model.Aa17aContaminante;
import com.ejie.aa17a.model.Aa17aContaminanteEstacion;
import com.ejie.aa17a.model.Aa17aEstacion;

/**
 * Aa17aContaminanteEstacionDaoImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aContaminanteEstacionDaoImpl implements Aa17aContaminanteEstacionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Aa17aContaminanteEstacion> rwMap = new RowMapper<Aa17aContaminanteEstacion>() {
		public Aa17aContaminanteEstacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Aa17aContaminanteEstacion registro = new Aa17aContaminanteEstacion();
			registro.setIdEstacion(resultSet.getLong("IDESTACION"));
			registro.setIdContaminante(resultSet.getLong("IDCONTAMINANTE"));

			Aa17aContaminante contaminante = new Aa17aContaminante();
			contaminante.setIdContaminante(resultSet.getLong("IDCONTAMINANTE"));
			contaminante.setNombreContaminante(resultSet.getString("NOMBRECONTAMINANTE"));
			contaminante.setUnidadMedida(resultSet.getString("UNIDADMEDIDA"));
			registro.setContaminante(contaminante);

			Aa17aEstacion estacion = new Aa17aEstacion();
			estacion.setIdEstacion(resultSet.getLong("IDESTACION"));
			estacion.setNombreEstacion(resultSet.getString("NOMBREESTACION"));
			estacion.setDireccionEstacion(resultSet.getString("DIRECCIONESTACION"));
			registro.setEstacion(estacion);

			//resultSet.getString("NOMBRECONTAMINANTE"

			return registro;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Devuelve los contaminantes de una estacion
	 * 
	 * @param aa17acontaminanteestacion
	 *            Aa17aContaminanteEstacion
	 * @return List<Aa17aContaminanteEstacion>
	 */
	@Transactional(readOnly = true)
	public List<Aa17aContaminanteEstacion> getContaminantes(Aa17aContaminanteEstacion aa17acontaminanteestacion) {
		StringBuilder query = new StringBuilder();
		query.append("SELECT  AA1703S00.T01_ESTACION_ID IDESTACION, AA1703S00.T02_CONTAMINANTE_ID IDCONTAMINANTE, ");
		query.append(" AA1702S00.T02_NOMBRE AS NOMBRECONTAMINANTE, ");
		query.append(" AA1701S00.T01_NOMBRE NOMBREESTACION, ");
		query.append(" AA1702S00.T02_UNIDAD_MEDIDA UNIDADMEDIDA, ");
		query.append(" AA1701S00.T01_DIRECCION DIRECCIONESTACION ");
		query.append(" FROM AA1703S00 ");
		query.append(" INNER JOIN AA1702S00 ON AA1702S00.T02_CONTAMINANTE_ID = AA1703S00.T02_CONTAMINANTE_ID ");
		query.append(" INNER JOIN AA1701S00 ON AA1701S00.T01_ESTACION_ID = AA1703S00.T01_ESTACION_ID ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17acontaminanteestacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Aa17aContaminanteEstacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Devuelve los datos de una estacion y un contaminante
	 * 
	 * @param aa17acontaminanteestacion
	 *            Aa17aContaminanteEstacion
	 * @return List<Aa17aContaminanteEstacion>
	 */
	@Transactional(readOnly = true)
	public Aa17aContaminanteEstacion getContaminanteEstacion(Aa17aContaminanteEstacion aa17acontaminanteestacion) {
		StringBuilder query = new StringBuilder();
		query.append("SELECT  AA1703S00.T01_ESTACION_ID IDESTACION, AA1703S00.T02_CONTAMINANTE_ID IDCONTAMINANTE, ");
		query.append(" AA1702S00.T02_NOMBRE AS NOMBRECONTAMINANTE, ");
		query.append(" AA1701S00.T01_NOMBRE NOMBREESTACION, ");
		query.append(" AA1702S00.T02_UNIDAD_MEDIDA UNIDADMEDIDA, ");
		query.append(" AA1701S00.T01_DIRECCION DIRECCIONESTACION ");
		query.append(" FROM AA1703S00 ");
		query.append(" INNER JOIN AA1702S00 ON AA1702S00.T02_CONTAMINANTE_ID = AA1703S00.T02_CONTAMINANTE_ID ");
		query.append(" INNER JOIN AA1701S00 ON AA1701S00.T01_ESTACION_ID = AA1703S00.T01_ESTACION_ID ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17acontaminanteestacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (Aa17aContaminanteEstacion) DataAccessUtils.uniqueResult(this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray()));
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aContaminanteEstacion entity
	 * 
	 * @param aa17acontaminanteestacion
	 *            Aa17aContaminanteEstacion Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa17aContaminanteEstacion aa17acontaminanteestacion) {

		StringBuffer where = new StringBuffer(Aa17aContaminanteEstacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17acontaminanteestacion != null && aa17acontaminanteestacion.getIdEstacion() != null) {
			where.append(" AND AA1703S00.T01_ESTACION_ID = ?");
			params.add(aa17acontaminanteestacion.getIdEstacion());
		}
		if (aa17acontaminanteestacion != null && aa17acontaminanteestacion.getIdContaminante() != null) {
			where.append(" AND AA1703S00.T02_CONTAMINANTE_ID = ?");
			params.add(aa17acontaminanteestacion.getIdContaminante());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
